/*
 * @(#)DMLModel.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.dml.model;

import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import java.util.*;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * DMLModel.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 2006-01-18 Created.
 */
public class DMLModel extends AbstractSimulation {
    public final static ResourceBundleUtil labels = 
            ResourceBundleUtil.getBundle("ch.hslu.cm.dml.Labels", Locale.getDefault());
    /**
     * Enumeration of simulated concepts.
     */
    public final static int TABLE = 0;
    public final static int STATEMENT = 1;
    public final static int STREAM = 2;
    
    /** Creates a new instance. */
    public DMLModel() {
    }
    
    public SimulatedTable getSimulatedTable(String name) {
        // FIXME - Linear search!!
        // This is very slow, we should consider using hash maps for all
	// names 
        
       for (Iterator i = getElements().iterator(); i.hasNext(); ) {
           SimulatedElement elem = (SimulatedElement) i.next();
           if (elem.getSimulatedConcept() == TABLE) {
               SimulatedTable set = (SimulatedTable) elem;
               if (set.getName().equals(name)) {
                   return set;
               }
           }
       }
       
       return null;
    }
    
    public Collection<SimulatedTable> getSimulatedTables() {
        LinkedList<SimulatedTable> result = new LinkedList<SimulatedTable>();
        
       for (Iterator i = getElements().iterator(); i.hasNext(); ) {
           SimulatedElement elem = (SimulatedElement) i.next();
           if (elem.getSimulatedConcept() == TABLE) {
               result.add((SimulatedTable) elem);
           }
       }
       
       return result;
    }
    
    public SimulatedObject create(int simulatedConcept) {
        SimulatedObject elem;
        switch (simulatedConcept) {
            case TABLE :
                elem = new SimulatedTable();
                break;
            case STATEMENT :
                elem = new SimulatedStatement();
                break;
            case STREAM :
                elem = new SimulatedStream();
                break;
            default :
                throw new IllegalArgumentException(simulatedConcept+"");
        }
        return elem;
    }
    
    /**
     * Unwraps a text representation of an attribute value into an object.
     */
    public Object unwrapValue(String text) {
        Object value;
        if (text == null || text.length() == 0 || text.equals("null")) {
            value = null;
        } else {
            Double number;
            try {
                number = Double.valueOf(text);
            } catch (NumberFormatException e) {
                number = null;
            }
            if (number != null) {
                value = number;
            } else if (text.charAt(0) == '"' || text.charAt(0) == '\'') {
                value = text.substring(1, text.length() - 1);
            } else {
                // value is a pointer to another simulated object
                // or simulated class.
                value = text;
                for (Iterator i=getElements().iterator(); i.hasNext(); ) {
                    SimulatedElement element = (SimulatedElement) i.next();
                    if (element.getName() != null && element.getName().equals(text)) {
                        value = element;
                        break;
                    }
                }
            }
        }
        return value;
    }
    /**
     * Wraps an attribute value into a text presentation.
     */
    public String wrapValue(Object value) {
        String text;
        if (value != null && (value instanceof String)) {
            text = "\""+value+"\"";
        } else if (value instanceof Number) {
            text = ""+value;
            
            // We don't want trailing '.0' in numbers. It looks awkward.
            if (text.length() > 2 && text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
        } else {
            text = ""+value;
        }
        return text;
    }
    
}